using System;

class SegmentTree
{
    private int[] treeXor;
        private int[] treeAnd;
            private int n;

                public SegmentTree(int[] arr)
                    {
                            n = arr.Length;
                                    treeXor = new int[4 * n];
                                            treeAnd = new int[4 * n];
                                                    Build(arr, 0, 0, n - 1);
                                                        }

                                                            private void Build(int[] arr, int node, int start, int end)
                                                                {
                                                                        if (start == end)
                                                                                {
                                                                                            treeXor[node] = arr[start];
                                                                                                        treeAnd[node] = arr[start];
                                                                                                                }
                                                                                                                        else
                                                                                                                                {
                                                                                                                                            int mid = (start + end) / 2;
                                                                                                                                                        Build(arr, 2 * node + 1, start, mid);
                                                                                                                                                                    Build(arr, 2 * node + 2, mid + 1, end);
                                                                                                                                                                                treeXor[node] = treeXor[2 * node + 1] ^ treeXor[2 * node + 2];
                                                                                                                                                                                            treeAnd[node] = treeAnd[2 * node + 1] & treeAnd[2 * node + 2];
                                                                                                                                                                                                    }
                                                                                                                                                                                                        }

                                                                                                                                                                                                            public (int, int) Query(int L, int R, int node, int start, int end)
                                                                                                                                                                                                                {
                                                                                                                                                                                                                        if (R < start || end < L)
                                                                                                                                                                                                                                    return (0, int.MaxValue); // XOR identity and AND identity
                                                                                                                                                                                                                                            if (L <= start && end <= R)
                                                                                                                                                                                                                                                        return (treeXor[node], treeAnd[node]);

                                                                                                                                                                                                                                                                int mid = (start + end) / 2;
                                                                                                                                                                                                                                                                        var left = Query(L, R, 2 * node + 1, start, mid);
                                                                                                                                                                                                                                                                                var right = Query(L, R, 2 * node + 2, mid + 1, end);
                                                                                                                                                                                                                                                                                        return (left.Item1 ^ right.Item1, left.Item2 & right.Item2);
                                                                                                                                                                                                                                                                                            }

                                                                                                                                                                                                                                                                                                public (int, int) Query(int L, int R)
                                                                                                                                                                                                                                                                                                    {
                                                                                                                                                                                                                                                                                                            return Query(L, R, 0, 0, n - 1);
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                }

                                                                                                                                                                                                                                                                                                                class Program
                                                                                                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                                                                                                    static int MaxXorAndProduct(int[] A, int[] B)
                                                                                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                                                                                                int n = A.Length;
                                                                                                                                                                                                                                                                                                                                        SegmentTree segmentTreeA = new SegmentTree(A);
                                                                                                                                                                                                                                                                                                                                                SegmentTree segmentTreeB = new SegmentTree(B);

                                                                                                                                                                                                                                                                                                                                                        int maxProduct = 0;
                                                                                                                                                                                                                                                                                                                                                                for (int L = 0; L < n; L++)
                                                                                                                                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                                                                                                                                                    for (int R = L; R < n; R++)
                                                                                                                                                                                                                                                                                                                                                                                                {
                                                                                                                                                                                                                                                                                                                                                                                                                var xorResult = segmentTreeA.Query(L, R);
                                                                                                                                                                                                                                                                                                                                                                                                                                var andResult = segmentTreeB.Query(L, R);
                                                                                                                                                                                                                                                                                                                                                                                                                                                maxProduct = Math.Max(maxProduct, xorResult.Item1 * andResult.Item2);
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }

                                                                                                                                                                                                                                                                                                                                                                                                                                                                            return maxProduct;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    static void Main()
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                int N = int.Parse(Console.ReadLine());
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        int[] A = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                int[] B = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        int result = MaxXorAndProduct(A, B);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                Console.WriteLine(result);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }